/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package com.inet.authentication.passwordfile.structure;

/*
    i-net software provides programming examples for illustration only, without warranty
    either expressed or implied, including, but not limited to, the implied warranties
    of merchantability and/or fitness for a particular purpose. This programming example
    assumes that you are familiar with the programming language being demonstrated and
    the tools used to create and debug procedures. i-net software support professionals
    can help explain the functionality of a particular procedure, but they will not modify
    these examples to provide added functionality or construct procedures to meet your
    specific needs.
    © i-net software 1998-2017
*/

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.inet.authentication.passwordfile.PasswordFileAuthProvider;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;

/**
 * The ConfigStructureProvider of the password file authentication plugin.
 * 
 * It defines structure of the properties that will be available to be specified in Configuration Manager.
 */
public class PasswordFileAuthStructureProvider extends AbstractStructureProvider {

    public static final String PASSWORD_FILE = PasswordFileAuthProvider.NAME + ".path";

    private static final String ACTION        = PasswordFileAuthProvider.NAME + ".action";

    /**
     * {@inheritDoc}
     */
    @Override
    public void addConditionsTo( @Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void addPropertiesTo( @Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
        switch( propertyGroupKey ) {
            case ACTION:
                // adds property for password file's path
                addTo( configProperties, PASSWORD_FILE, ConfigProperty.FILE, "", settings );
                break;
            default:
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void validate( @Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings ) {
        ConfigValidator validator = new ConfigValidator( messages, settings );
        if( ACTION.equals( categoryKey ) ) {
            // it should not be possible to specify path that denotes non-existing password file
            validator.checkNotEmpty( settings.getValue( PASSWORD_FILE ), PASSWORD_FILE );
            validator.checkFileExists( settings.getValue( PASSWORD_FILE ), PASSWORD_FILE );
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void addGroupsTo( @Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void addCategoriesTo( @Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public URL getCategoryIcon( @Nonnull String categoryKey ) {
        // nothing
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void addPropertyGroupsTo( @Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
        // nothing
    }
}
